from factscorer import FactScorer
import json
import os
from dotenv import load_dotenv
import argparse


parser = argparse.ArgumentParser()
parser.add_argument("-dp", "--data_path", type=str, default="../data/gen_factscore.json", help="Path to the dataset")
parser.add_argument("-rp", "--result_path", type=str, default="../res/res_factscore.json", help="Path to the output file")
args = parser.parse_args()

load_dotenv()
api_key = os.getenv("OPENAI_API_KEY")
fs = FactScorer(openai_key = api_key)

with open(args.data_path, "r") as f:
    dataset = json.load(f)   

topics, generations = [], []
for data in dataset:
    topic = data['Prompt']

    for response in data['Responses']:
        topics.append(topic)
        generations.append(response)
        
fs.get_score(topics, generations, result_path=args.result_path)
